%This program is used to compute TS from IC data. It will be called by 
%control_limit_ar2_boots.m for computing the control limit for AR(q) model.
%x,y are the raw data.
%u0,s0 are the mean function and variance function estimated from IC data.
%n2 out n1 is the sampling rate
%k is the reference value
%h0 is the bandwidth.

function ts=ATS_Dar2_data(x,y,u0,s0,n2,n1,k,h0)
L=length(u0);
n=length(x(1,:));
J=length(x(:,1));
B=round(L.*x);
B(ceil(L/n1)*n2+1,:)=L+1;
coun=0;
repp=1;
while (repp<=n)
    T=B(1,repp);
    count=1;
    Cn=max(0,(y(count,repp)-u0(T))/s0(T)-k);
    while (Cn<=h0) && (T<=L) && (repp<=n)
         T=B(count+1,repp);
if T>=L+1
    break
else
 Cn=max(0,Cn+(y(count+1,repp)-u0(T))/s0(T)-k);
count=count+1;
end
    end
repp=repp+1;
if T<=L
    coun=coun+1;
ts(coun)=T-B(1,repp-1);
end
end
